# A Tcl script for the Qsys system console

# Start Qsys, open your soc_system.qsys file, run File->System Console,
# then execute this script by selecting it with Ctrl-E

# The System Console is described in Chapter 10 of Volume III of
# the Quartus II Handbook

# Alternately,
# system-console --project_dir=. --script=syscon-test.tcl
#
# system-console --project_dir=. -cli
#   and then "source syscon-test.tcl"

# Base addresses of the peripherals: take from Qsys
set ccl 0x0

puts "Started system-console-test-script"

# Using the JTAG chain, check the clock and reset"

set j [lindex [get_service_paths jtag_debug] 0]
open_service jtag_debug $j
puts "Opened jtag_debug"

puts "Checking the JTAG chain loopback: [jtag_debug_loop $j {1 2 3 4 5 6}]"
jtag_debug_reset_system $j

puts -nonewline "Sampling the clock: "
foreach i {1 1 1 1 1 1 1 1 1 1 1 1} {
    puts -nonewline [jtag_debug_sample_clock $j]
}
puts ""

puts "Checking reset state: [jtag_debug_sample_reset $j]"

close_service jtag_debug $j
puts "Closed jtag_debug"

# Perform bus reads and writes

set m [lindex [get_service_paths master] 0]
open_service master $m
puts "Opened master"

# Write a test pattern to the various registers
#foreach {r v} {0 0x0080} {
#    master_write_16 $m [expr $vga_led + $r] $v
#}
#puts [master_write_32 $m [expr $ccl + 2048] 0x0009BDC2]
#puts [master_write_32 $m [expr $ccl + 0] 0x00034]
#master_write_32 $m [expr $ccl + 0] 0x17000003
#master_write_32 $m [expr $ccl + 8] 0x17000005
#puts [master_write_32 $m [expr $ccl + 2048] 0x0009BDC2]
#master_write_32 $m [expr $ccl + 8] 0x000AB
#master_write_32 $m [expr $ccl + 12] 0x0009C
master_write_32 $m [expr $ccl + 4*182] 0x00000
master_write_32 $m [expr $ccl + 4*180] 0x00001


for {set a 0} {$a < 15} {incr a 1} {
	puts "counter is $a"
	puts "write_ready is [master_read_32 $m [expr $ccl + 4*184] 1]"
	puts "read_ready is [master_read_32 $m [expr $ccl + 4*185] 1]"
	puts "data_ready is [master_read_32 $m [expr $ccl + 4*198] 1]"
	puts "write_row is [master_read_32 $m [expr $ccl + 4*187] 1]"
	puts "read_row is [master_read_32 $m [expr $ccl + 4*188] 1]"
	puts "active_row is [master_read_32 $m [expr $ccl + 4*199] 1]"
	puts "top_row is [master_read_32 $m [expr $ccl + 4*200] 1]"
	puts "row_filled0 is [master_read_32 $m [expr $ccl + 4*189] 1]"
	puts "row_filled1 is [master_read_32 $m [expr $ccl + 4*190] 1]"
	puts "row_filled2 is [master_read_32 $m [expr $ccl + 4*191] 1]"
	puts "row_processed0 is [master_read_32 $m [expr $ccl + 4*192] 1]"
	puts "row_processed1 is [master_read_32 $m [expr $ccl + 4*193] 1]"
	puts "row_processed2 is [master_read_32 $m [expr $ccl + 4*194] 1]"
	puts "reading_row0 is [master_read_32 $m [expr $ccl + 4*195] 1]"
	puts "reading_row1 is [master_read_32 $m [expr $ccl + 4*196] 1]"
	puts "reading_row2 is [master_read_32 $m [expr $ccl + 4*197] 1]"
	if {[master_read_32 $m [expr $ccl + 4*184] 1]} then {
		puts "write_row is: ..."
		puts [master_read_32 $m [expr $ccl + 4*187] 1]
		for {set b 0} {$b < 4*160} {incr b 4} {
			master_write_32 $m [expr $ccl + $b] $b
			puts "Wrote into address $b"
		}
		puts "Read row: ..."
		puts [master_read_32 $m [expr $ccl + 4*188] 1]
	} elseif {[master_read_32 $m [expr $ccl + 4*185] 1]} then {
		puts "read_row is: ..."
		puts [master_read_32 $m [expr $ccl + 4*188] 1]
		for {set b 0} {$b < 4*160} {incr b 4} {
			puts [master_read_32 $m [expr $ccl + $b] 1]
			if {$b < 12 || $b > 4*157} then {
				puts "reading_row0 is [master_read_32 $m [expr $ccl + 4*195] 1]"
				puts "reading_row1 is [master_read_32 $m [expr $ccl + 4*196] 1]"
				puts "reading_row2 is [master_read_32 $m [expr $ccl + 4*197] 1]"
			}
		}
	} 
	puts "aja"
}

#for {set a 0} {$a < 100} {incr a 4} {
#	puts "Value at address = $a"
#	puts [master_read_32 $m [expr $ccl + $a] 1]
#}
#puts [master_read_32 $m [expr $ccl + 4*184] 1]
#puts [master_read_32 $m [expr $ccl + 0] 1]
#puts [master_read_32 $m [expr $ccl + 8] 1]
#puts [master_read_32 $m [expr $ccl + 8] 4]
#puts [master_read_32 $m [expr $ccl + 12] 1]
#puts [master_read_32 $m [expr $ccl + 16] 1]
#puts [master_read_32 $m [expr $ccl + 32] 1]
#puts [master_read_32 $m [expr $ccl + 28] 1]
#puts [master_read_32 $m [expr $ccl + 36] 1]
#puts [master_read_32 $m [expr $ccl + 128] 1]
#puts [master_read_32 $m [expr $ccl + 736] 1]
#puts [master_read_32 $m [expr $ccl + 2044] 1]
#master_write_16 $m [expr $ccl + 0] 0x10 0x10
#master_write_16 $m [expr $ccl + 0] 0x140 0xF0

close_service master $m
puts "Closed master"




